function varargout = grid_generator_qu(varargin)
%GRID_GENERATOR_QU MATLAB code file for grid_generator_qu.fig
% Written by Qu
% Last Modified by GUIDE v2.5 29-Oct-2019 10:18:25

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @grid_generator_qu_OpeningFcn, ...
    'gui_OutputFcn',  @grid_generator_qu_OutputFcn, ...
    'gui_LayoutFcn',  [], ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before grid_generator_qu is made visible.
function grid_generator_qu_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for grid_generator_qu
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes grid_generator_qu wait for user response (see UIRESUME)
% uiwait(handles.figure1);
%variables
global set0 set1 set2 set3 set4 set5 set6 set7 set8 rx ry im_grid px pt1_gl deg1
set0 = []; %temporary set
set1 = [];
set2 = [];
set3 = [];
set4 = [];
set5 = [];
set6 = [];
set7 = [];
set8 = [];
rx = 4;
ry = 4;
px=4;
pt1_gl = 4;
deg1=4;

[ImageName,Pathname]=uigetfile({'*.pgm;*.png;*.tif;*.tiff','Image files (*.m,*.png,*.tif,*.tiff)'},'Choose Image File');
ImageName=[Pathname ImageName];
if length(ImageName)<2
    im_grid=ones(800);
else
    im_grid = imread(ImageName);
end
imshow(im_grid);

% --- Outputs from this function are returned to the command line.
function varargout = grid_generator_qu_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pb_loadimg.
function pb_loadimg_Callback(hObject, eventdata, handles)
global im_grid
ImageName=uigetfile({'*.pgm;*.png;*.tif;*.tiff','Image files (*.m,*.png,*.tif,*.tiff)'},'Choose Image File');
if length(ImageName)<2
    im_grid=ones(800);
else
    im_grid = imread(ImageName);
end
imshow(im_grid);


% --- Executes when selected object is changed in uibuttongroup2.
function uibuttongroup2_SelectionChangedFcn(hObject, eventdata, handles)
update_grid(hObject, eventdata, handles)


% --- Executes on button press in pb_loadgrid.
function pb_loadgrid_Callback(hObject, eventdata, handles)

global set0 set1 set2 set3 set4 set5 set6 set7 set8
data='';
data=uigetfile('grid.dat','Choose grid.dat');

if length(data)>3
    temp = load(data);
    set1 = temp(temp(1,1):temp(1,2)-1,:);
    set2 = temp(temp(1,2):temp(2,1)-1,:);
    set3 = temp(temp(2,1):temp(2,2)-1,:);
    set4 = temp(temp(2,2):temp(3,1)-1,:);
    set5 = temp(temp(3,1):temp(3,2)-1,:);
    set6 = temp(temp(3,2):temp(4,1)-1,:);
    set7 = temp(temp(4,1):temp(4,2)-1,:);
    set8 = temp(temp(4,2):length(temp),:);
    set0 = temp(5:temp(1,1)-1,:);
    update_grid(hObject, eventdata, handles) %redraw
end



% --- Executes on button press in pb_savegrid.
function pb_savegrid_Callback(hObject, eventdata, handles)

global set0 set1 set2 set3 set4 set5 set6 set7 set8
grid = [set0;set1;set2;set3;set4;set5;set6;set7;set8];  %including current grid set0
dlmwrite('grid_x.dat',grid(:,1),'delimiter','\t');
dlmwrite('grid_y.dat',grid(:,2),'delimiter','\t');
tmp = 5+length(set0)+length(set1)+length(set2)+length(set3)+length(set4);

grid = [5+length(set0)                   5+length(set0)+length(set1);...
    tmp-length(set4)-length(set3)    tmp-length(set4);...
    tmp                              tmp+length(set5);...
    tmp+length(set5)+length(set7)    5+length(grid)-length(set8) ;...
    grid];  %including current grid set0
dlmwrite('grid.dat',grid,'delimiter','\t');
grid = [];


function ed_rectx_Callback(hObject, eventdata, handles)
global rx
temp = str2double(get(hObject,'String'));
if isnan(temp)
    errordlg('You must enter a numeric value','Invalid Input','modal')
    uicontrol(hObject)
    return
else
    rx = temp;
end

% --- Executes during object creation, after setting all properties.
function ed_rectx_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ed_recty_Callback(hObject, eventdata, handles)
global ry
temp = str2double(get(hObject,'String'));
if isnan(temp)
    errordlg('You must enter a numeric value','Invalid Input','modal')
    uicontrol(hObject)
    return
else
    ry = temp;
end


% --- Executes during object creation, after setting all properties.
function ed_recty_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb_addpoints.
function pb_addpoints_Callback(hObject, eventdata, handles)
global set0 set1 set2 set3 set4 set5 set6 set7 set8
switch get(get(handles.uibuttongroup2,'SelectedObject'), 'Tag');
    case 'rb_set1'
        set1 = [set1;set0];
    case 'rb_set2'
        set2 = [set2;set0];
    case 'rb_set3'
        set3 = [set3;set0];
    case 'rb_set4'
        set4 = [set4;set0];
    case 'rb_set5'
        set5 = [set5;set0];
    case 'rb_set6'
        set6 = [set6;set0];
    case 'rb_set7'
        set7 = [set7;set0];
    case 'rb_set8'
        set8 = [set8;set0];
end


if get(handles.keeppoints,'Value')==0
    set0 = [];
end
update_grid(hObject, eventdata, handles)

% --- Executes on button press in pb_chooserect.
function pb_chooserect_Callback(hObject, eventdata, handles)
global rx ry set0
[x1,y1]=ginput(1);
[x2,y2]=ginput(1);

hold on

if (rx==1)||(ry==1)
    new = [linspace(x1,x2,rx*ry)' linspace(y1,y2,rx*ry)'];
    set0 = [set0;new];
    plot(new(:,1),new(:,2),'+g')
else
    new = combvec(linspace(x1,x2,rx),linspace(y1,y2,ry))';
    set0 = [set0;new];
    plot(new(:,1),new(:,2),'+g')
end


drawnow

% --- Executes on button press in pb_up.
function pb_up_Callback(hObject, eventdata, handles)
global set0 px
if not(isempty(set0))
    set0(:,2)=set0(:,2)-px;
    update_grid(hObject, eventdata, handles) %redraw
end

% --- Executes on button press in pb_down.
function pb_down_Callback(hObject, eventdata, handles)
global set0 px
if not(isempty(set0))
    set0(:,2)=set0(:,2)+px;
    update_grid(hObject, eventdata, handles) %redraw
end

% --- Executes on button press in pb_left.
function pb_left_Callback(hObject, eventdata, handles)
global set0 px
if not(isempty(set0))
    set0(:,1)=set0(:,1)-px;
    update_grid(hObject, eventdata, handles) %redraw
end


% --- Executes on button press in pb_right.
function pb_right_Callback(hObject, eventdata, handles)
global set0 px
if not(isempty(set0))
    set0(:,1)=set0(:,1)+px;
    update_grid(hObject, eventdata, handles) %redraw
end


function ed_points_Callback(hObject, eventdata, handles)
global pt1_gl
temp = str2double(get(hObject,'String'));
if isnan(temp)
    errordlg('You must enter a numeric value','Invalid Input','modal')
    uicontrol(hObject)
    return
else
    pt1_gl = temp;
end

% --- Executes during object creation, after setting all properties.
function ed_points_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb_choosepoints.
function pb_choosepoints_Callback(hObject, eventdata, handles)
global pt1_gl set0

for temp = 1:pt1_gl
    [x1,y1]=ginput(1);
    hold on
    set0 = [set0;[x1,y1]];
    plot(x1,y1,'+g')
    drawnow
end


% --- Executes on button press in pb_delnew.
function pb_delnew_Callback(hObject, eventdata, handles)
global set0
set0 = [];
update_grid(hObject, eventdata, handles)


function ed_pixels_Callback(hObject, eventdata, handles)
global px
temp = str2double(get(hObject,'String'));
if isnan(temp)
    errordlg('You must enter a numeric value','Invalid Input','modal')
    uicontrol(hObject)
    return
else
    px = temp;
end

% --- Executes during object creation, after setting all properties.
function ed_pixels_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb_deletecurrentset.
function pb_deletecurrentset_Callback(hObject, eventdata, handles)
global set0 set1 set2 set3 set4 set5 set6 set7 set8 im_grid
hold off
imshow(im_grid);
hold on
if not(isempty(set0))
    plot(set0(:,1),set0(:,2),'+g')
end
switch get(get(handles.uibuttongroup2,'SelectedObject'), 'Tag');
    case 'rb_set1'
        set1=[];
    case 'rb_set2'
        set2=[];
    case 'rb_set3'
        set3=[];
    case 'rb_set4'
        set4=[];
    case 'rb_set5'
        set5=[];
    case 'rb_set6'
        set6=[];
    case 'rb_set7'
        set7=[];
    case 'rb_set8'
        set8=[];
end


% --- Executes on button press in pb_saveclose.
function pb_saveclose_Callback(hObject, eventdata, handles)
pb_savegrid_Callback(hObject, eventdata, handles)
close grid_generator_qu

% --- Executes on button press in pb_copygrid.
function pb_copygrid_Callback(hObject, eventdata, handles)
global set0 set1 set2 set3 set4 set5 set6 set7 set8
switch get(get(handles.uibuttongroup2,'SelectedObject'), 'Tag');
    case 'rb_set1'
        set0=[set0; set1];
        plot(set1(:,1),set1(:,2),'+g')
    case 'rb_set2'
        set0=[set0; set2];
        plot(set2(:,1),set2(:,2),'+g')
    case 'rb_set3'
        set0=[set0; set3];
        plot(set3(:,1),set3(:,2),'+g')
    case 'rb_set4'
        set0=[set0; set4];
        plot(set4(:,1),set4(:,2),'+g')
    case 'rb_set5'
        set0=[set0; set5];
        plot(set5(:,1),set5(:,2),'+g')
    case 'rb_set6'
        set0=[set0; set6];
        plot(set6(:,1),set6(:,2),'+g')
    case 'rb_set7'
        set0=[set0; set7];
        plot(set7(:,1),set7(:,2),'+g')
    case 'rb_set8'
        set0=[set0; set8];
        plot(set8(:,1),set8(:,2),'+g')
end




function ed_degrees_Callback(hObject, eventdata, handles)
global deg1
temp = str2double(get(hObject,'String'));
if isnan(temp)
    errordlg('You must enter a numeric value','Invalid Input','modal')
    uicontrol(hObject)
    return
else
    deg1 = temp;
end

% --- Executes during object creation, after setting all properties.
function ed_degrees_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in pb_rotplus.
function pb_rotplus_Callback(hObject, eventdata, handles)
global deg1 set0
if length(set0)>1
    ang1 = -deg1*pi/180; %direction is different because y-axis faces down
    temp = mean(set0);
    rot1 = [cos(ang1) -sin(ang1);sin(ang1) cos(ang1)];
    
    set0 = ((rot1*(set0-temp)')'+temp);
    update_grid(hObject, eventdata, handles)
else
    return
end


% --- Executes on button press in pb_rotneg.
function pb_rotneg_Callback(hObject, eventdata, handles)
global deg1 set0
if length(set0)>1
    ang1 = deg1*pi/180;
    temp = mean(set0);
    rot1 = [cos(ang1) -sin(ang1);sin(ang1) cos(ang1)];
    set0 = ((rot1*(set0-temp)')'+temp);
    update_grid(hObject, eventdata, handles)
else
    return
end

% --- Updates visual
function update_grid(hObject, eventdata, handles)
global set0 set1 set2 set3 set4 set5 set6 set7 set8 im_grid
hold off
imshow(im_grid);
hold on

switch get(get(handles.uibuttongroup2,'SelectedObject'), 'Tag')
    case 'rb_set1'
        if not(isempty(set1))
            plot(set1(:,1),set1(:,2),'+r')
        end
    case 'rb_set2'
        if not(isempty(set2))
            plot(set2(:,1),set2(:,2),'+r')
        end
    case 'rb_set3'
        if not(isempty(set3))
            plot(set3(:,1),set3(:,2),'+r')
        end
    case 'rb_set4'
        if not(isempty(set4))
            plot(set4(:,1),set4(:,2),'+r')
        end
    case 'rb_set5'
        if not(isempty(set5))
            plot(set5(:,1),set5(:,2),'+r')
        end
    case 'rb_set6'
        if not(isempty(set6))
            plot(set6(:,1),set6(:,2),'+r')
        end
    case 'rb_set7'
        if not(isempty(set7))
            plot(set7(:,1),set7(:,2),'+r')
        end
    case 'rb_set8'
        if not(isempty(set8))
            plot(set8(:,1),set8(:,2),'+r')
        end
        
end

if not(isempty(set0))
    plot(set0(:,1),set0(:,2),'+g')
end


% --- Executes on button press in keeppoints.
function keeppoints_Callback(hObject, eventdata, handles)


% --- Executes during object deletion, before destroying properties.
function ed_points_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to ed_points (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press with focus on ed_points and none of its controls.
function ed_points_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to ed_points (see GCBO)
% eventdata  structure with the following fields (see MATLAB.UI.CONTROL.UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
